from django.db import models
from django.db.models import Max

from . import choices


class AssignmentManager(models.Manager):

    def create(self, *args, **kwargs):
        from intranet.femida.src.interviews.models import Assignment

        assignment = self.model(**kwargs)

        if 'position' not in kwargs:
            position = (
                Assignment.objects
                .filter(interview=assignment.interview)
                .aggregate(max_position=Max('position'))['max_position']
            )
            assignment.position = position + 1 if position is not None else 0

        assignment.save(force_insert=True)
        return assignment


class InterviewQuerySet(models.QuerySet):

    def hr_screenings(self):
        return self.filter(type=choices.INTERVIEW_TYPES.hr_screening)

    def screenings(self):
        return self.filter(type=choices.INTERVIEW_TYPES.screening)

    def regular(self):
        return self.filter(type=choices.INTERVIEW_TYPES.regular)

    def aa(self):
        return self.filter(type=choices.INTERVIEW_TYPES.aa)

    def finals(self):
        return self.filter(type=choices.INTERVIEW_TYPES.final)

    def gradable(self):
        return self.filter(type__in=choices.INTERVIEW_GRADABLE_TYPES._db_values)

    def alive(self):
        return self.filter(state__in=choices.INTERVIEW_ALIVE_STATES._db_values)


InterviewManager = models.Manager.from_queryset(InterviewQuerySet)
