# Generated by Django 1.11.2 on 2018-08-20 19:08
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager
import django.utils.timezone
import intranet.femida.src.core.db.fields
import intranet.femida.src.wf.models
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('candidates', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Application',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                (
                    'status',
                    models.CharField(
                        choices=[
                            ('draft', 'application.status.draft'),
                            ('in_progress', 'application.status.in_progress'),
                            ('closed', 'application.status.closed')
                        ],
                        default='draft',
                        max_length=32,
                    ),
                ),
                (
                    'resolution',
                    models.CharField(
                        blank=True,
                        choices=[
                            ('test_task_sent', 'application.resolution.test_task_sent'),
                            ('test_task_done', 'application.resolution.test_task_done'),
                            ('invited_to_preliminary_interview', 'application.resolution.invited_to_preliminary_interview'),
                            ('invited_to_onsite_interview', 'application.resolution.invited_to_onsite_interview'),
                            ('invited_to_final_interview', 'application.resolution.invited_to_final_interview'),
                            ('offer_agreement', 'application.resolution.offer_agreement'),
                            ('did_not_pass_assessments', 'application.resolution.did_not_pass_assessments'),
                            ('team_was_not_interested', 'application.resolution.team_was_not_interested'),
                            ('team_was_not_selected', 'application.resolution.team_was_not_selected'),
                            ('refused_us', 'application.resolution.refused_us'),
                            ('offer_rejected', 'application.resolution.offer_rejected'),
                            ('offer_accepted', 'application.resolution.offer_accepted'),
                            ('rotated', 'application.resolution.rotated'),
                            ('vacancy_closed', 'application.resolution.vacancy_closed'),
                            ('incorrect', 'application.resolution.incorrect'),
                            ('on_hold', 'application.resolution.on_hold'),
                            ('consideration_archived', 'application.resolution.consideration_archived'),
                            ('rejected_by_resume', 'application.resolution.rejected_by_resume'),
                            ('rejected_after_test_task', 'application.resolution.rejected_after_test_task'),
                            ('rejected_after_screening', 'application.resolution.rejected_after_screening'),
                            ('rejected_after_preliminary_interview', 'application.resolution.rejected_after_preliminary_interview'),
                            ('rejected_after_onsite_interview', 'application.resolution.rejected_after_onsite_interview'),
                            ('rejected_after_final_interview', 'application.resolution.rejected_after_final_interview'),
                            ('refused_did_not_respond', 'application.resolution.refused_did_not_respond'),
                            ('refused_after_vacancy_proposal', 'application.resolution.refused_after_vacancy_proposal'),
                            ('refused_after_test_task', 'application.resolution.refused_after_test_task'),
                            ('refused_after_screening', 'application.resolution.refused_after_screening'),
                            ('refused_after_preliminary_interview', 'application.resolution.refused_after_preliminary_interview'),
                            ('refused_after_onsite_interview', 'application.resolution.refused_after_onsite_interview'),
                            ('refused_after_final_interview', 'application.resolution.refused_after_final_interview'),
                            ('duplicate', 'application.resolution.duplicate'),
                            ('no_offer', 'application.resolution.no_offer'),
                        ],
                        default='',
                        max_length=64,
                    ),
                ),
                ('status_changed', models.DateTimeField(auto_now_add=True)),
                ('rank', models.SmallIntegerField(default=0)),
                ('comment', models.TextField(blank=True, default='')),
                ('source', models.CharField(choices=[('recruiter', 'application.source.recruiter'), ('submission', 'application.source.submission'), ('proposal', 'application.source.proposal'), ('request', 'application.source.request')], default='recruiter', max_length=16)),
                (
                    'proposal_status',
                    models.CharField(
                        blank=True,
                        choices=[
                            ('undefined', 'application.proposal_status.undefined'),
                            ('accepted', 'application.proposal_status.accepted'),
                            ('rejected', 'application.proposal_status.rejected'),
                        ],
                        default='undefined',
                        max_length=32,
                        null=True,
                    ),
                ),
            ],
            options={
                'default_manager_name': 'unsafe',
            },
            managers=[
                ('unsafe', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='Assignment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('comment', models.TextField(blank=True, default='')),
                ('formatted_comment', models.TextField(blank=True, default='')),
                ('grade', models.SmallIntegerField(blank=True, choices=[(1, '\u041f\u043b\u043e\u0445\u043e'), (3, '\u041d\u043e\u0440\u043c'), (5, '\u041e\u0442\u043b\u0438\u0447\u043d\u043e')], null=True)),
                ('position', models.IntegerField(default=0)),
            ],
            options={
                'ordering': ['position'],
            },
            bases=(intranet.femida.src.wf.models.WFModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Interview',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('type', models.CharField(choices=[('screening', 'interview.type.screening'), ('regular', 'interview.type.regular'), ('aa', 'interview.type.aa'), ('hr_screening', 'interview.type.hr_screening'), ('final', 'interview.type.final')], default='regular', max_length=16, null=True)),
                ('state', models.CharField(
                    choices=[
                        ('draft', 'Черновик'),
                        ('assigned', 'Назначена'),
                        ('estimated', 'Оценена'),
                        ('finished', 'Завершена'),
                        ('cancelled', 'Отменена'),
                    ],
                    default='assigned',
                    max_length=32,
                )),
                ('resolution', models.CharField(blank=True, choices=[('hire', 'interview.resolution.hire'), ('nohire', 'interview.resolution.nohire')], default='', max_length=32, null=True)),
                ('finished', models.DateTimeField(blank=True, null=True)),
                ('comment', models.TextField(blank=True, default='')),
                ('formatted_comment', models.TextField(blank=True, default='')),
                ('cancel_reason', models.TextField(blank=True)),
                ('grade', models.SmallIntegerField(blank=True, choices=[(0, '\u041e\u0442\u043a\u0430\u0437\u0430\u0442\u044c'), (1, '\u041d\u0430\u043d\u044f\u0442\u044c, I \u0421\u0442\u0430\u0436\u0451\u0440'), (2, '\u041d\u0430\u043d\u044f\u0442\u044c, II \u041c\u043b\u0430\u0434\u0448\u0438\u0439 \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u0438\u0441\u0442'), (3, '\u041d\u0430\u043d\u044f\u0442\u044c, III \u0421\u043f\u0435\u0446\u0438\u0430\u043b\u0438\u0441\u0442'), (4, '\u041d\u0430\u043d\u044f\u0442\u044c, IV \u0421\u043f\u0435\u0446\u0438\u0430\u043b\u0438\u0441\u0442'), (5, '\u041d\u0430\u043d\u044f\u0442\u044c, V \u0421\u0442\u0430\u0440\u0448\u0438\u0439 \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u0438\u0441\u0442'), (6, '\u041d\u0430\u043d\u044f\u0442\u044c, VI \u0412\u0435\u0434\u0443\u0449\u0438\u0439 \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u0438\u0441\u0442'), (7, '\u041d\u0430\u043d\u044f\u0442\u044c, VII \u0412\u0435\u0434\u0443\u0449\u0438\u0439 \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u0438\u0441\u0442'), (8, '\u041d\u0430\u043d\u044f\u0442\u044c, VIII \u042d\u043a\u0441\u043f\u0435\u0440\u0442')], null=True)),
                ('is_pro_level_scale', models.BooleanField(blank=True, default=True)),
                ('event_id', models.IntegerField(blank=True, null=True)),
                ('event_start_time', models.DateTimeField(blank=True, null=True)),
                ('section', models.CharField(blank=True, default='', max_length=255)),
                ('sent', models.BooleanField(blank=True, default=False)),
                (
                    'aa_type',
                    models.CharField(
                        blank=True,
                        choices=[
                            ('canonical', 'interview.aa_type.canonical'),
                            ('frontend', 'interview.aa_type.frontend'),
                            ('management', 'interview.aa_type.management'),
                            ('ml', 'interview.aa_type.ml'),
                            ('architecture', 'interview.aa_type.architecture'),
                        ],
                        max_length=32,
                        null=True,
                    )
                ),
                ('is_code', models.BooleanField(blank=True, default=False)),
                ('startrek_review_key', intranet.femida.src.core.db.fields.StartrekIssueKeyField(blank=True, max_length=32, null=True)),
                ('application', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='interviews', to='interviews.Application')),
                ('candidate', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='interviews', to='candidates.Candidate')),
                ('consideration', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='interviews', to='candidates.Consideration')),
            ],
            options={
                'default_manager_name': 'unsafe',
            },
            bases=(intranet.femida.src.wf.models.WFModelMixin, models.Model),
            managers=[
                ('unsafe', django.db.models.manager.Manager()),
            ],
        ),
    ]
