# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2018-09-24 15:16
from django.db import migrations

from intranet.femida.src.interviews.choices import APPLICATION_STATUSES, APPLICATION_RESOLUTIONS


def migrate_rejected_applications(apps, schema_editor):
    Application = apps.get_model('interviews', 'Application')
    Application.unsafe.filter(status='rejected').update(
        status=APPLICATION_STATUSES.closed,
        resolution=APPLICATION_RESOLUTIONS.team_was_not_interested,
    )


class Migration(migrations.Migration):

    dependencies = [
        ('interviews', '0003_remove_recruiter_and_responsibles_from_application'),
    ]

    operations = [
        migrations.RunPython(migrate_rejected_applications, reverse_code=lambda *x, **y: None)
    ]
