# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2018-09-28 15:16
from django.db import migrations

from intranet.femida.src.interviews.choices import APPLICATION_PROPOSAL_STATUSES


def migrate_proposal_statuses(apps, schema_editor):
    Application = apps.get_model('interviews', 'Application')

    Application.unsafe.filter(
        proposal_status='ignored',
    ).update(
        proposal_status=APPLICATION_PROPOSAL_STATUSES.undefined,
    )

    Application.unsafe.filter(
        proposal_status='accepted_by_team',
    ).update(
        proposal_status=APPLICATION_PROPOSAL_STATUSES.accepted,
    )

    Application.unsafe.filter(
        proposal_status='rejected_by_team',
    ).update(
        proposal_status=APPLICATION_PROPOSAL_STATUSES.rejected,
    )


class Migration(migrations.Migration):

    dependencies = [
        ('interviews', '0004_remove_application_status_rejected'),
    ]

    operations = [
        migrations.RunPython(migrate_proposal_statuses, reverse_code=lambda *x, **y: None)
    ]
