# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2018-09-28 17:16
from django.db import migrations

from intranet.femida.src.interviews.choices import APPLICATION_STATUSES


def migrate_requested_applications(apps, schema_editor):
    Application = apps.get_model('interviews', 'Application')
    Application.unsafe.filter(status='requested').update(
        status=APPLICATION_STATUSES.in_progress,
        resolution='team_is_interested',
        proposal_status='accepted',
    )


def migrate_proposed_applications(apps, schema_editor):
    Application = apps.get_model('interviews', 'Application')
    Application.unsafe.filter(status='proposed').update(
        status='in_progress',
        resolution='proposed',
    )


class Migration(migrations.Migration):

    dependencies = [
        ('interviews', '0005_update_proposal_statuses'),
    ]

    operations = [
        migrations.RunPython(migrate_requested_applications, reverse_code=lambda *x, **y: None),
        migrations.RunPython(migrate_proposed_applications, reverse_code=lambda *x, **y: None),
    ]
