# Generated by Django 2.2.9 on 2020-08-03 13:22

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('staff', '0007_office_red_rose'),
        ('candidates', '0018_candidate_submission_remove_null'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('interviews', '0007_add_proposal_factors'),
    ]

    operations = [
        migrations.CreateModel(
            name='InterviewRound',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('type', models.CharField(
                    choices=[
                        ('screening', 'interview_round.type.screening'),
                        ('onsite', 'interview_round.type.onsite'),
                        ('final', 'interview_round.type.final'),
                    ],
                    max_length=16,
                )),
                ('status', models.CharField(
                    choices=[
                        ('new', 'interview_round.status.new'),
                        ('planning', 'interview_round.status.planning'),
                        ('planned', 'interview_round.status.planned'),
                        ('cancelled', 'interview_round.status.cancelled'),
                    ],
                    default='new',
                    max_length=32,
                )),
                ('planner', models.CharField(
                    blank=True,
                    choices=[
                        ('femida', 'interview_round.planner.femida'),
                        ('yang', 'interview_round.planner.yang'),
                    ],
                    max_length=16,
                )),
                ('is_strict_order', models.BooleanField(default=False, help_text='Порядок секций важен?')),
                ('lunch_duration', models.IntegerField(
                    choices=[
                        (0, 'interview_round.lunch_duration.no_lunch'),
                        (30, 'interview_round.lunch_duration.minutes_30'),
                        (60, 'interview_round.lunch_duration.minutes_60'),
                        (90, 'interview_round.lunch_duration.minutes_90'),
                    ],
                    default=0,
                    help_text='Время перерыва на обед в минутах',
                )),
                ('candidate', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='candidates.Candidate')),
                ('consideration', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='interview_rounds', to='candidates.Consideration')),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('office', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='staff.Office')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='interview',
            name='potential_interviewers',
            field=models.ManyToManyField(blank=True, related_name='_interview_potential_interviewers_+', to=settings.AUTH_USER_MODEL),
        ),
        migrations.CreateModel(
            name='InterviewRoundTimeSlot',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start', models.DateTimeField()),
                ('end', models.DateTimeField()),
                ('round', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='time_slots', to='interviews.InterviewRound')),
            ],
        ),
        migrations.AddField(
            model_name='interview',
            name='round',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='interviews', to='interviews.InterviewRound'),
        ),
    ]
