from intranet.femida.src.vacancies.controllers import get_relevant_prof_sphere_ids_qs


def get_acl_for_search(user):
    login_filter = '(s_login:>"{login}" | s_login:<"{login}")'.format(
        login=user.username
    )
    if user.is_recruiter:
        return login_filter
    if user.is_recruiter_assessor:
        return f'{login_filter} & i_is_current_employee:0'

    sphere_ids = set(get_relevant_prof_sphere_ids_qs(user))
    spheres_filter = ' | '.join('i_professional_sphere:%d' % i for i in sphere_ids)

    acl_template = '{login_filter} & ('
    if sphere_ids:
        acl_template += (
            '(({spheres_filter}) & '
            'i_is_current_employee:0 &'
            'i_has_only_hidden_vacancies:0 & '
            'i_is_hidden:0) | '
        )
    acl_template += 's_interviewer:"{login}" | s_vacancy_access:"{login}")'
    acl = acl_template.format(
        login_filter=login_filter,
        login=user.username,
        spheres_filter=spheres_filter,
    )
    return acl
