from django.conf import settings

from intranet.femida.src.celery_app import app
from .api import make_push_request


@app.autoretry_task(max_retries=3)
def push_candidate_to_isearch(candidate_id):
    url = settings.ISEARCH_PUSH_BASE_URL + 'candidates/'
    make_push_request(url, {'id': candidate_id})


@app.task
def bulk_push_candidates_to_isearch(candidate_ids):
    for candidate_id in candidate_ids:
        try:
            push_candidate_to_isearch(candidate_id)
        except Exception:
            push_candidate_to_isearch.delay(candidate_id)


@app.autoretry_task(max_retries=3)
def push_vacancy_to_isearch(vacancy_id):
    url = settings.ISEARCH_PUSH_BASE_URL + 'candidates/'
    make_push_request(
        url=url,
        data={
            'filters': {
                'vacancy': vacancy_id,
            },
        },
    )


@app.task
def bulk_push_vacancies_to_isearch(vacancy_ids):
    for vacancy_id in vacancy_ids:
        try:
            push_vacancy_to_isearch(vacancy_id)
        except Exception:
            push_vacancy_to_isearch.delay(vacancy_id)
