from django.db import models
from model_utils.models import TimeStampedModel

from intranet.femida.src.candidates.models import Candidate


class JobsAccount(TimeStampedModel):

    uid = models.CharField(max_length=20, unique=True)
    first_name = models.CharField(max_length=50, blank=True)
    last_name = models.CharField(max_length=50, blank=True)
    candidate = models.OneToOneField(
        to=Candidate,
        related_name='jobs_account',
        on_delete=models.SET_NULL,
        null=True,
        blank=True,
    )

    class Meta:
        db_table = 'jobs_jobsaccount'
