# Generated by hallucinite on 2021-12-06

from django.db import migrations


def fill_public_professional_sphere(apps, schema_editor):
    ProfessionalSphere = apps.get_model('professions', 'ProfessionalSphere')
    PublicProfessionalSphere = apps.get_model('public_professions', 'PublicProfessionalSphere')
    PublicProfession = apps.get_model('public_professions', 'PublicProfession')

    professional_spheres = ProfessionalSphere.objects.all()
    for professional_sphere in professional_spheres:
        public_professional_sphere = PublicProfessionalSphere.objects.create(
            slug=professional_sphere.slug,
            name_ru=professional_sphere.name,
            name_en=professional_sphere.name_en or '',
            description_ru=professional_sphere.description_ru or '',
            description_en=professional_sphere.description_en or '',
            position=professional_sphere.position,
        )
        professional_sphere.public_professions.all().update(
            public_professional_sphere=public_professional_sphere,
        )
    assert not PublicProfession.objects.filter(public_professional_sphere__isnull=True).exists()


class Migration(migrations.Migration):

    dependencies = [
        ('public_professions', '0002_public_professional_sphere'),
    ]

    operations = [
        migrations.RunPython(
            code=fill_public_professional_sphere,
            reverse_code=migrations.RunPython.noop,
        ),
    ]
