from django.db import models
from model_utils.models import TimeStampedModel

from intranet.femida.src.core.managers import ActiveManager
from intranet.femida.src.core.models import I18NNameModelMixin
from intranet.femida.src.professions.models import Profession, ProfessionalSphere


class PublicProfessionalSphere(I18NNameModelMixin, TimeStampedModel):
    """
    Справочник профсфер для сайта вакансий
    """
    slug = models.CharField(max_length=255, unique=True, null=True)
    name_ru = models.CharField(max_length=255)
    name_en = models.CharField(max_length=255)
    description_ru = models.TextField(blank=True)
    description_en = models.TextField(blank=True)
    position = models.IntegerField(default=0)

    def __str__(self):
        return self.name

    class Meta:
        db_table = 'jobs_publicprofessionalsphere'


class PublicProfession(I18NNameModelMixin, TimeStampedModel):
    """
    Справочник профессий для сайта вакансий
    """
    objects = models.Manager()
    active = ActiveManager()

    slug = models.CharField(max_length=255, unique=True, null=True)
    name_ru = models.CharField(max_length=255)
    name_en = models.CharField(max_length=255, null=True)
    is_active = models.BooleanField(default=True)
    position = models.IntegerField(default=0)

    professions = models.ManyToManyField(
        to=Profession,
        related_name='public_professions',
    )
    professional_sphere = models.ForeignKey(
        to=ProfessionalSphere,
        related_name='public_professions',
        on_delete=models.PROTECT,
    )
    public_professional_sphere = models.ForeignKey(
        to=PublicProfessionalSphere,
        related_name='public_professions',
        on_delete=models.PROTECT,
        null=True,
    )

    class Meta:
        db_table = 'professions_publicprofession'

    def __str__(self):
        return self.name
