import datetime

from django.utils import timezone


def get_candidate():
    return {
        'id': 1,
        'first_name': 'Король',
        'last_name': 'Лир',
        'full_name': 'Король Лир',
        'target_cities': ['Москва', 'Санкт-Петербург'],
        'professions': ['Frontend Developer', 'Backend Developer'],
        'city': 'Амстердам',
        'skills': ['Python', 'JS'],
        'responsibles': [
            get_user(),
            get_user(),
        ],
    }


def get_interview():
    return {
        'id': 1,
        'type': 'regular',
        'section': 'Секция',
        'grade': 5,
        'grade_display': 'Нанять. Специалист (V)',
        'is_hire': True,
        'interviewer': get_user(),
        'finished': timezone.now(),
        'comment': 'Комментарий',
        'formatted_comment': '<div>Ко<b>мм</b>ентарий</div>',
        'event_url': 'https://calendar.testing.yandex-team.ru/event/?event_id=11552',
    }


def get_vacancy():
    return {
        'id': 1,
        'name': 'Вакансия',
        'status': 'closed',
        'status_display': 'Закрыта',
        'cities': ['Москва', 'Санкт-Петербург'],
        'profession': 'Backend Developer',
        'pro_level_min_display': 'Стажер',
        'pro_level_max_display': 'Специалист',
        'skills': ['Python', 'JS'],
    }


def get_user():
    return {
        'username': 'annvas',
        'full_name': 'Анна Васильева',
        'gender': 'female',
        'timezone': 'UTC',
    }


def get_application():
    return {
        'id': 1,
        'status': 'in_progress',
        'status_display': 'Закрыто',
        'proposal_status': 'undefined',
        'resolution_display': 'Отказано по результатам секций'
    }


def get_application_with_vacancy(is_receiver_team_member=True):
    return {
        'id': 1,
        'is_receiver_team_member': is_receiver_team_member,
        'vacancy': get_vacancy(),
    }


def get_internal_message():
    return {
        'id': 1,
        'type': 'brief',
        'html': '<div>Ко<b>мм</b>ентарий</div>',
    }


def get_attachment():
    return {
        'id': 1,
        'name': "image.png",
    }


def get_event():
    start_time = timezone.now() + datetime.timedelta(days=30)
    return {
        'id': 1,
        'name': 'Name1',
        'start_time': start_time,
        'end_time': start_time + datetime.timedelta(hours=1),
        'rooms_str': 'Room1',
    }
