from django import template
from django.conf import settings

from intranet.femida.src.vacancies.choices import VACANCY_STATUSES
from intranet.femida.src.interviews.choices import APPLICATION_STATUSES

register = template.Library()


VACANCY_STATUSES_BG_COLORS = {
    VACANCY_STATUSES.draft: 'gray',
    VACANCY_STATUSES.on_approval: 'orange',
    VACANCY_STATUSES.in_progress: 'green',
    VACANCY_STATUSES.suspended: 'gray',
    VACANCY_STATUSES.offer_processing: 'orange-light',
    VACANCY_STATUSES.offer_accepted: 'blue-light',
    VACANCY_STATUSES.closed: 'blue',
}

APPLICATION_STATUSES_BG_COLORS = {
    APPLICATION_STATUSES.draft: 'gray',
    APPLICATION_STATUSES.in_progress: 'green',
    APPLICATION_STATUSES.closed: 'gray',
}

UNKNOWN_STATUS_BG_COLOR = 'color-black'


@register.inclusion_tag('mail/partials/ya.html')
def ya(staff_user, with_login=False, inflection_form=None, *args, **kwargs):
    return {
        'staff_user': staff_user,
        'with_login': with_login,
        'femida_url': settings.FEMIDA_URL,
        'staff_url': settings.STAFF_URL,
        'inflection_form': inflection_form,
    }


@register.filter
def vacancy_color(status, *args, **kwargs):
    return VACANCY_STATUSES_BG_COLORS.get(status, UNKNOWN_STATUS_BG_COLOR)


@register.filter
def application_color(status, *args, **kwargs):
    return APPLICATION_STATUSES_BG_COLORS.get(status, UNKNOWN_STATUS_BG_COLOR)
