import logging

from django import http
from django.conf import settings
from django.core.mail import EmailMessage
from django.views.generic.base import TemplateView

from premailer import Premailer

from . import mock


logger = logging.getLogger(__name__)


def transform_callback(response):
    response.content = Premailer(response.content.decode('utf-8'), remove_classes=True).transform()


class EmailView(TemplateView):
    """
    Базовая вьюха для работы с версткой писем.
    Метод get отдает на фронт html письма как есть.
    Метод post отправляет письмо на почту.
    В get_context_data содержится контекст шаблона письма.

    TODO: На понять что делать с subject. Он у нас устанавливается в классах Notification.
    Дублировать в этих вьюхах не хочется. Но хотелось бы отправлять дебажные письма с темой.
    Кажется нужен какой-то рефакторинг в этом месте.
    """
    def get_context_data(self, **kwargs):
        return {
            'initiator': mock.get_user(),
            'receiver': mock.get_user(),
            'femida_url': settings.FEMIDA_URL,
            'staff_url': settings.STAFF_URL,
            'candidate': mock.get_candidate(),
            'vacancy': mock.get_vacancy(),
            'vacancies': [mock.get_vacancy(), mock.get_vacancy()],
            'interviews': [mock.get_interview(), mock.get_interview()],
            'application': mock.get_application(),
            'applications': [
                mock.get_application_with_vacancy(),
                mock.get_application_with_vacancy(is_receiver_team_member=False),
            ],
            'message': mock.get_internal_message(),
            'attachments': [mock.get_attachment(), mock.get_attachment()],
            'event': mock.get_event(),
            'interview': mock.get_interview(),
        }

    def get(self, request, *args, **kwargs):
        context = self.get_context_data(**kwargs)
        context['show_send_button'] = True
        response = self.render_to_response(context)
        response.add_post_render_callback(transform_callback)
        return response

    def post(self, *args, **kwargs):
        context = self.get_context_data(**kwargs)
        response = self.render_to_response(context)
        response.render()
        response.add_post_render_callback(transform_callback)

        msg = EmailMessage(
            subject=self.template_name,
            body=response.content.decode('utf-8'),
            from_email=settings.DEFAULT_FROM_EMAIL,
            to=[settings.DEBUG_EMAIL],
        )
        msg.content_subtype = 'html'
        msg.send()

        return http.HttpResponse('OK')
