import os

SECRET_KEY = '1'
DEBUG = True
ALLOWED_HOSTS = ['*']
DATABASES = {}
IS_LOCAL = True

FEMIDA_URL = 'https://femida.yandex-team.ru/'
STAFF_URL = 'https://staff.yandex-team.ru/'

INSTALLED_APPS = (
    'intranet.femida.src',
    'intranet.femida.src.mail',
)

MIDDLEWARE = ()

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [],
            'debug': True,
        },
    },
]

ROOT_URLCONF = 'intranet.femida.src.mail.urls'

DEFAULT_FROM_EMAIL = 'robot-femida@yandex-team.ru'
DEBUG_EMAIL = 'mtest@yandex-team.ru'

EMAIL_HOST = 'outbound-relay.yandex.net'
EMAIL_PORT = 25

TIME_ZONE = 'UTC'
USE_TZ = True

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'handlers': {
        'console': {
            'level': 'DEBUG',
            'class': 'logging.StreamHandler',
            'formatter': 'verbose',
        },
    },
    'formatters': {
        'verbose': {
            'format': '%(levelname)s %(asctime)s %(name)s %(message)s'
        },
    },
    'loggers': {
        'intranet.femida': {
            'handlers': ['console'],
            'level': 'DEBUG',
            'propagate': False,
        },
    },
    'root': {
        'handlers': ['console'],
        'level': 'DEBUG',
    }
}

if os.getenv('IS_ARCADIA'):
    from library.python.django.utils import patch_settings_for_arcadia
    patch_settings_for_arcadia()
