import re

from django.http import HttpResponse
from django.utils.deprecation import MiddlewareMixin

from .checkpoints import irreversible_checkpoints


class AliveMiddleware(MiddlewareMixin):
    """
    Простенькая миддлварина, через которую можно проверить,
    что приложение запущено
    """
    ping_re = re.compile(r'^/ping/?$')

    def process_request(self, request):
        if self.ping_re.match(request.path):
            return HttpResponse("I'm alive!")


class IrreversibleCheckpointsMiddleware(MiddlewareMixin):
    """
    Позволяет трекать необратимые изменения
    """
    def process_request(self, request):
        irreversible_checkpoints.init()

    def process_exception(self, request, exception):
        irreversible_checkpoints.close()
