from django_celery_monitoring.utils import clean_old_celery_results, fail_aborted_celery_results

from intranet.femida.src.celery_app import app
from intranet.femida.src.utils.lock import locked_task


@app.task
def alarm_task(message, data):
    """
    Таск-костыль. Зажигает мониторинг celery_tasks.
    Нужен для того, чтобы в реальном времени узнавать о каких-то важных событиях.
    """
    raise Exception(message)


@app.task
@locked_task
def clean_old_celery_results_task():
    clean_old_celery_results()


@app.task
@locked_task
def fail_aborted_celery_results_task():
    fail_aborted_celery_results()
