import logging

from intranet.femida.src.monitoring.tasks import alarm_task


logger = logging.getLogger(__name__)


def alarm(message, data=None, on_transaction_commit=False, with_log=True):
    """
    "Громкое" логгирование.
    Если о какой-то проблеме/ошибке нужно узнать явно в реальном времени,
    можно вызвать эту функцию – загорится мониторинг celery_tasks.

    :param message: сообщение об ошибке
    :param data: данные/контекст ошибки
    :param on_transaction_commit: True, если нужно вызвать alarm_task
      только при успешном завершении текущей транзакции в БД
    """
    data = data or {}
    if with_log:
        logger.error('Sending alarm: %s, %s', message, data)
    exception = None
    for _ in range(3):
        try:
            alarm_task.apply_async(
                args=(message,),
                kwargs={'data': data},
                on_transaction_commit=on_transaction_commit,
            )
            break
        except Exception as exc:
            exception = exc
    else:
        logger.error('Alarm failure: %s', exception)
