from intranet.femida.src.notifications.base import FetchingNotificationBase, R
from intranet.femida.src.notifications.utils import get_candidate_message_id


def get_challenge_email_subject(challenge, prefix):
    subject = '[{prefix}] {full_name}'.format(
        prefix=prefix,
        full_name=challenge.candidate.get_full_name(),
    )
    if challenge.application:
        subject = '{} — {}'.format(subject, challenge.application.vacancy.composite_name)
    return subject


candidate_responsibles_rcv = R(lambda x: x.instance.candidate.responsibles.all())
initiator_rcv = R(lambda x: [x.initiator])


class ChallengeNotification(FetchingNotificationBase):

    subject_prefix = None

    def get_subject(self):
        return get_challenge_email_subject(self.instance, self.subject_prefix)

    def get_thread_id(self):
        return get_candidate_message_id(self.instance.candidate)


class ChallengeEstimatedNotification(ChallengeNotification):

    subject_prefix = 'Тестовое задание оценено'
    template_name = 'email/challenges/estimate.html'
    receivers = candidate_responsibles_rcv - initiator_rcv
