from django.db import models
from django.conf import settings

from model_utils.models import TimeStampedModel

from intranet.femida.src.problems.models import Category


class CategorySubscription(TimeStampedModel):
    category = models.ForeignKey(
        to=Category,
        on_delete=models.CASCADE,
        related_name='subscriptions',
    )
    user = models.ForeignKey(
        to=settings.AUTH_USER_MODEL,
        on_delete=models.CASCADE,
        related_name='subscriptions',
    )
