from django.conf import settings

from intranet.femida.src.notifications.base import FetchingNotificationBase, R
from intranet.femida.src.notifications.serializers import (
    PublicationSubscriptionSerializer,
    VacancySerializer,
)


created_by_rcv = R(lambda x: [x.instance.created_by])


class PublicationSubscriptionNotification(FetchingNotificationBase):

    subject = '[Вакансии] Новые объявления'
    template_name = 'mail/publications/new-publications.html'
    receivers = created_by_rcv

    def get_common_context(self):
        context = super().get_common_context()

        vacancies = self.kwargs['vacancies']
        context['vacancies_count'] = len(vacancies)
        vacancies = vacancies[:settings.SUBSCRIPTIONS_DIGEST_LENGTH]
        context['vacancies'] = VacancySerializer(vacancies, many=True).data

        subscription_data = PublicationSubscriptionSerializer(self.instance).data
        context['subscription'] = subscription_data
        context['has_params'] = any(subscription_data.values())
        return context
