from django.contrib import admin

from intranet.femida.src.core.admin import pretty_json
from . import models


class OEBSLogAdmin(admin.ModelAdmin):

    list_display = (
        'object_id',
        'content_type',
        'action',
        'created',
    )

    exclude = ('raw_oebs_data', 'raw_related_data')
    readonly_fields = ('pretty_oebs_data', 'pretty_related_data')

    def pretty_oebs_data(self, obj):
        return pretty_json(obj.oebs_data)

    def pretty_related_data(self, obj):
        return pretty_json(obj.related_data)


admin.site.register(models.OEBSLog, OEBSLogAdmin)
