from intranet.femida.src.utils.switches import is_bp_always_valid


class _Any(str):
    def __eq__(self, other):
        return True

    def __ne__(self, other):
        return False


_bp_sample_data = {
    'RK': None,
    'SN': None,
    'availableFunds': 90000,
    'budgetOrg': 'БО Яндекс, все без Турции',
    'businessGroup': 'Яндекс, Россия (БГ)/Yandex, Russia (BG)',
    'currency': 'RUB',
    'department': 'Обособленное подразделение в Санкт-Петербурге',
    'foodLimit': 9700,
    'grade': 15,
    'headcount': 'да',
    'hiringDate': '2017-05-01',
    'manager': 'dmirain',
    'office': 'БЦ "Морозов", Москва',
    'organization': 'ООО Яндекс',
    'paySystem': 'XXYA_FIXED_SALARY',
    'product': '(Не активно)',
    'profLevel': '3',
    'profession': 'Other',
    'rate': 1,
    'recCountry': 'Российская Федерация',
    'salary': 100000,
}


def get_fake_bp(bp_id):
    bp_data = _bp_sample_data.copy()
    if is_bp_always_valid():
        bp_data['hiring'] = _Any('OFFER')
    elif bp_id <= 10000:
        bp_data['hiring'] = 'VACANCY'
    elif bp_id <= 20000:
        bp_data['hiring'] = 'OFFER'
    else:
        bp_data['hiring'] = 'EMPTY'

    return bp_data
