from intranet.femida.src.celery_app import app
from intranet.femida.src.oebs.api import OebsAPI, OebsHireAPI
from intranet.femida.src.offers.models import Offer


@app.autoretry_task(max_retries=3)
def update_bank_login_task(old_login, new_login):
    OebsAPI.update_bank_login(old_login, new_login)


@app.autoretry_task(max_retries=3)
def update_oebs_login_task(person_id, login):
    OebsHireAPI.update_login(person_id, login)


@app.autoretry_task(max_retries=3)
def remove_oebs_person_task(person_id):
    OebsHireAPI.remove_person(person_id)


@app.autoretry_task(max_retries=3)
def update_oebs_assignment_task(offer_id):
    offer = Offer.unsafe.get(id=offer_id)
    OebsHireAPI.update_assignment(
        person_id=offer.oebs_person_id,
        department_id=offer.department_id,
        join_at=offer.join_at,
    )
