from django.utils.translation import ugettext_noop as _
from model_utils.choices import Choices

import intranet.femida.src.offers.citizenship_choices as sc

OPEN_OFFER_STATUSES = Choices(
    ('draft', _('offer.status.draft')),              # черновик
    ('ready_for_approval', _('offer.status.ready_for_approval')),  # готов к согласованию
    ('on_rotation_approval', _('offer.status.on_rotation_approval')),  # согласование ротации
    ('on_approval', _('offer.status.on_approval')),  # согласование
    ('sent', _('offer.status.sent')),                # отправлен кандидату
    ('accepted', _('offer.status.accepted')),        # принят
    ('confirmed', _('offer.status.confirmed')),      # подтвержден рекрутером
)
CLOSED_OFFER_STATUSES = Choices(
    ('closed', _('offer.status.closed')),           # закрыт
    ('rejected', _('offer.status.rejected')),       # отклонен (не принят/отказ)
    ('deleted', _('offer.status.deleted')),         # удален
)
OFFER_STATUSES = OPEN_OFFER_STATUSES + CLOSED_OFFER_STATUSES

OFFER_STATUSES_TRANSLATIONS = {
    OFFER_STATUSES.draft: 'Черновик',
    OFFER_STATUSES.ready_for_approval: 'Готов к согласованию',
    OFFER_STATUSES.on_rotation_approval: 'Согласование ротации',
    OFFER_STATUSES.on_approval: 'Согласование',
    OFFER_STATUSES.sent: 'Отправлен кандидату',
    OFFER_STATUSES.accepted: 'Принят',
    OFFER_STATUSES.confirmed: 'Подтвержден',
    OFFER_STATUSES.closed: 'Закрыт',
    OFFER_STATUSES.rejected: 'Отклонен',
    OFFER_STATUSES.deleted: 'Удален',
}

OFFER_DOCS_PROCESSING_STATUSES = Choices(
    ('in_progress', _('offer.docs_processing_status.in_progress')),
    ('need_information', _('offer.docs_processing_status.need_information')),
    ('finished', _('offer.docs_processing_status.finished')),
)

OFFER_DOCS_PROCESSING_SKIPPED_RESOLUTIONS = Choices(
    'skipped_no_docs_to_check',
    'skipped_person_found',
    'skipped_no_docs_to_process',
    'skipped_oohrc_org',  # out of HR control organization
    'skipped_foreigner',
)

OFFER_DOCS_PROCESSING_RESOLUTIONS = OFFER_DOCS_PROCESSING_SKIPPED_RESOLUTIONS + Choices(
    'expired',
    'failed',
    'processed',
)

OFFER_YANG_TABLE_COLUMNS = Choices(
    'passport',
    'snils',
    'residence_address',
    'registration_address',
)

OFFER_DOC_DATA_FIELDS = Choices(
    'passport_data',
    'snils_number',
    'residence_address_data',
    'registration_address_data',
)

DOCUMENT_TYPES = Choices(
    'russian_passport', _('offer.document_type.russian_passport'),
    'other', _('offer.document_type.other'),
)

DOCUMENT_TYPES_TRANSLATIONS = {
    DOCUMENT_TYPES.russian_passport: 'Паспорт гражданина РФ',
    DOCUMENT_TYPES.other: 'Другое',
}


OFFER_NEWHIRE_STATUSES = Choices(
    ('new', _('offer.newhire_status.new')),              # новый / принят кандидатом
    ('prepared', _('offer.newhire_status.prepared')),    # заполнен кандидатом
    ('approved', _('offer.newhire_status.approved')),    # подтвержден руководителем
    ('ready', _('offer.newhire_status.ready')),          # подготовка рабочего места
    ('closed', _('offer.newhire_status.closed')),        # добавлен на стафф
    ('cancelled', _('offer.newhire_status.cancelled')),  # отменен
)

WORK_PLACES = Choices(
    ('office', _('offer.work_place.office')),
    ('home', _('offer.work_place.home')),
)

PAYMENT_TYPES = Choices(
    ('monthly', _('offer.payment_type.monthly')),
    ('hourly', _('offer.payment_type.hourly')),
    ('piecework', _('offer.payment_type.piecework')),
)

PAYMENT_TYPES_TRANSLATIONS = {
    PAYMENT_TYPES.monthly: 'Месячный оклад',
    PAYMENT_TYPES.hourly: 'Часовая ставка',
    PAYMENT_TYPES.piecework: 'Сдельная оплата труда',
}

EMPLOYMENT_TYPES = Choices(
    ('full', _('offer.employment_type.full')),
    ('partial', _('offer.employment_type.partial')),
)


EXTERNAL_EMPLOYEE_TYPES = Choices(
    ('new', _('offer.employee_type.new')),
    ('former', _('offer.employee_type.former')),
    ('current', _('offer.employee_type.current')),
)

INTERNAL_EMPLOYEE_TYPES = Choices(
    # Note: здесь есть логический рассинхрон.
    # На бэке эти значения считаются "типом сотрудника",
    # а на фронте это всё называется "тип вывода".
    # Поэтому один из типов называется "ротация",
    # что не очень релевантно для "типа сотрудника",
    # но очень удобно для заказчиков.
    ('rotation', _('offer.employee_type.rotation')),
    ('intern', _('offer.employee_type.intern')),
)

EMPLOYEE_TYPES = EXTERNAL_EMPLOYEE_TYPES + INTERNAL_EMPLOYEE_TYPES

EMPLOYEE_TYPES_TRANSLATIONS = {
    EMPLOYEE_TYPES.new: 'Новый сотрудник',
    EMPLOYEE_TYPES.former: 'Бывший сотрудник',
    EMPLOYEE_TYPES.current: 'Действующий внешний консультант',
    EMPLOYEE_TYPES.rotation: 'Ротация',
    EMPLOYEE_TYPES.intern: 'После стажировки',
}


OFFER_FORM_CONTRACT_TYPES = Choices(
    ('indefinite', _('offer.contract_type.indefinite')),
    ('fixed_term', _('offer.contract_type.fixed_term')),
    ('fixed_term_date', _('offer.contract_type.fixed_term_date')),
    ('temp_replacement', _('offer.contract_type.temp_replacement')),
)

# TODO: Убрать из всех мест в коде после релиза FEMIDA-5387
#  и когда не будет активных офферов с типом CONTRACT_TYPES.project
CONTRACT_TYPES = OFFER_FORM_CONTRACT_TYPES + Choices(
    ('project', _('offer.contract_type.project')),
)

CONTRACT_TYPES_TRANSLATIONS = {
    CONTRACT_TYPES.indefinite: 'Бессрочный',
    CONTRACT_TYPES.fixed_term: 'Срочный',
    CONTRACT_TYPES.fixed_term_date: 'Срочный до даты',
    CONTRACT_TYPES.project: 'Срочный на проект',
    CONTRACT_TYPES.temp_replacement: 'На срок отсутствия основного сотрудника',
}

PROBATION_PERIOD_UNITS = Choices(
    ('week', _('offer.probation_period_unit.week')),
    ('month', _('offer.probation_period_unit.month')),
)

# Допутимые варианты испытательных сроков.
# Раньше можно было указать любое значение в неделях или месяцах.
# В БД продолжаем хранить как и раньше. Эти варианты используются только в форме.
PROBATION_PERIOD_TYPES = Choices(
    ('no', _('offer.probation_period.no')),
    ('2w', 'two_weeks', _('offer.probation_period.two_weeks')),
    ('3m', 'three_months', _('offer.probation_period.three_months')),
    ('6m', 'six_months', _('offer.probation_period.six_months')),
)

PROBATION_PERIOD_TYPE_TO_UNITS = {
    PROBATION_PERIOD_TYPES.no: (0, PROBATION_PERIOD_UNITS.month),
    PROBATION_PERIOD_TYPES.two_weeks: (2, PROBATION_PERIOD_UNITS.week),
    PROBATION_PERIOD_TYPES.three_months: (3, PROBATION_PERIOD_UNITS.month),
    PROBATION_PERIOD_TYPES.six_months: (6, PROBATION_PERIOD_UNITS.month),
}
PROBATION_PERIOD_UNIT_TO_TYPES = {v: k for k, v in PROBATION_PERIOD_TYPE_TO_UNITS.items()}

FORM_TYPES = Choices(
    ('russian', _('offer.form_type.russian')),
    ('international', _('offer.form_type.international')),
)

GENDER = Choices(
    ('M', _('offer_profile.gender.male')),
    ('F', _('offer_profile.gender.female')),
)

GENDER_TRANSLATIONS = {
    GENDER.M: 'Мужской',
    GENDER.F: 'Женский',
}

# TODO: Тут надо все порефакторить.
#       Сделано для обратной совместимости, чтобы если и поломать, то чуть-чуть.
#       Скоро на стаффе обогатится география, на неё и перейдем.
CITIZENSHIP = sc.CITIZENSHIP

CITIZENSHIP_RU = sc.CITIZENSHIP_RU

CITIZENSHIP_EN = sc.CITIZENSHIP_EN

CITIZENSHIP_TRANSLATIONS = sc.CITIZENSHIP_TRANSLATIONS_RU

EMPLOYMENT_BOOK_OPTIONS = Choices(
    ('paper', _('offer_profile.employment_book.paper')),
    ('digital', _('offer_profile.employment_book.digital')),
    ('unavailable', _('offer_profile.employment_book.unavailable')),
    ('absent', _('offer_profile.employment_book.absent')),
)

EMPLOYMENT_BOOK_TRANSLATIONS = {
    EMPLOYMENT_BOOK_OPTIONS.paper: 'Бумажная',
    EMPLOYMENT_BOOK_OPTIONS.digital: 'Электронная',
    EMPLOYMENT_BOOK_OPTIONS.unavailable: 'Нет на руках',
    EMPLOYMENT_BOOK_OPTIONS.absent: 'Не заведена',
}

EDU_STATUSES = Choices(
    ('secondary', _('offer_profile.education.secondary')),
    ('incomplete', _('offer_profile.education.incomplete')),
    ('bachelor', _('offer_profile.education.bachelor')),
    ('master', _('offer_profile.education.master')),
    ('specialist', _('offer_profile.education.specialist')),
    ('academic', _('offer_profile.education.academic')),
)

EDU_DIRECTIONS = Choices(
    ('technical', _('offer_profile.education_direction.technical')),
    ('liberal', _('offer_profile.education_direction.liberal')),
    ('natural', _('offer_profile.education_direction.natural')),
    ('economic', _('offer_profile.education_direction.economic')),
    ('business', _('offer_profile.education_direction.business')),
)

AVAILABLE_OPERATING_SYSTEMS = Choices(
    ('ubuntu', _('offer_profile.operating_system.ubuntu')),
    ('mac', _('offer_profile.operating_system.mac')),
    ('windows', _('offer_profile.operating_system.windows')),
    ('none', _('offer_profile.operating_system.none')),
)

OPERATING_SYSTEMS = Choices(
    # FEMIDA-6071: Неактуальная ОС
    ('kubuntu', _('offer_profile.operating_system.kubuntu')),
) + AVAILABLE_OPERATING_SYSTEMS

# Аттачи, загружаемые кандидатом
OFFER_CANDIDATE_ATTACHMENT_TYPES = Choices(
    ('document', _('offer_attachment.type.document')),
    ('photo', _('offer_attachment.type.photo')),
    ('passport_page', _('offer_attachment.type.passport_page')),
    ('snils', _('offer_attachment.type.snils')),
)

OFFER_ATTACHMENT_TYPES = OFFER_CANDIDATE_ATTACHMENT_TYPES + Choices(
    ('offer_pdf', _('offer_attachment.type.offer_pdf')),
)

REJECTION_SIDES = Choices(
    ('candidate', _('offer.rejection_side.candidate')),
    ('recruiter', _('offer.rejection_side.recruiter')),
)

REJECTIONS_SIDE_TRANSLATIONS = {
    REJECTION_SIDES.candidate: 'Отказался кандидат',
    REJECTION_SIDES.recruiter: 'Удалил рекрутер',
}


# Поля специфичные для Стартрека

PROFESSIONAL_LEVELS = Choices(
    ('intern', _('pro_level.intern')),  # стажер
    ('junior', _('pro_level.junior')),  # младший
    ('middle', _('pro_level.middle')),  # специалист/руководитель
    ('senior', _('pro_level.senior')),  # старший
    ('lead', _('pro_level.lead')),      # ведущий
    ('expert', _('pro_level.expert')),  # эксперт
)

PROFESSIONAL_LEVELS_TRANSLATIONS = {
    PROFESSIONAL_LEVELS.intern: 'Стажер',
    PROFESSIONAL_LEVELS.junior: 'Младший',
    PROFESSIONAL_LEVELS.middle: 'Специалист',
    PROFESSIONAL_LEVELS.senior: 'Старший',
    PROFESSIONAL_LEVELS.lead: 'Ведущий',
    PROFESSIONAL_LEVELS.expert: 'Эксперт',
}


# TODO: вынести это в choices Кандидата
SOURCES = Choices(
    ('internal_reference', _('offer.source.internal_reference')),
    ('external_reference', _('offer.source.external_reference')),
    ('rotation', _('offer.source.rotation')),
    ('found_by_hiring_manager', _('offer.source.found_by_hiring_manager')),
    ('academic_project', _('offer.source.academic_project')),
    # TODO: переименовать это везде,
    # используется плохое название как раньше было в СТ
    ('expert_evaluation', _('offer.source.expert_evaluation')),
    ('candidates_list', _('offer.source.candidates_list')),
    ('agency', _('offer.source.agency')),
    ('implant', _('offer.source.implant')),
    ('yandex_job_website', _('offer.source.yandex_job_website')),
    ('candidates_base', _('offer.source.candidates_base')),
    ('external_website', _('offer.source.external_website')),
    ('internal_event', _('offer.source.internal_event')),
    ('external_event', _('offer.source.external_event')),
    ('networking', _('offer.source.networking')),
    ('other', _('offer.source.other')),
)

SOURCES_TRANSLATIONS = {
    SOURCES.internal_reference: 'Программа внутренних рекомендаций',
    SOURCES.external_reference: 'Программа внешних рекомендаций',
    SOURCES.rotation: 'Ротация',
    SOURCES.found_by_hiring_manager: 'Нашёл нанимающий менеджер',
    SOURCES.academic_project: 'Академ. проект',
    SOURCES.expert_evaluation: 'После стажировки',
    SOURCES.candidates_list: 'Обработка списков компаний',
    SOURCES.agency: 'Агентство',
    SOURCES.implant: 'Имплант',
    SOURCES.yandex_job_website: 'Отклик с Компани',
    SOURCES.candidates_base: 'Поднят из базы кандидатов',
    SOURCES.external_website: 'Внешний сайт',
    SOURCES.internal_event: 'Внутреннее мероприятие',
    SOURCES.external_event: 'Внешнее мероприятие',
    SOURCES.networking: 'Нетворкинг',
    SOURCES.other: 'Другое',
}

ST_PROGRAMMING_LANGUAGES = Choices(
    ('c_plus_plus_lang', 'C++'),
    ('c_lang', 'C'),
    ('java_lang', 'Java'),
    # FIXME: буква "с" на кириллице. Спасибо, Стартрек :/
    ('s\u0441ala_lang', 'scala_lang', 'Scala'),
    ('c_sharp_lang', 'C#'),
    ('lisp_lang', 'Lisp'),
    ('erlang_lang', 'Erlang'),
    ('haskell_lang', 'Haskell'),
    ('go_lang', 'Go'),
    ('python_lang', 'Python'),
    ('perl_lang', 'Perl'),
    ('ruby_lang', 'Ruby'),
    ('javascript_lang', 'JavaScript'),
    ('php_lang', 'PHP'),
    ('objective_c_lang', 'Objective-C'),
    ('swift_lang', 'Swift'),
    ('kotlin', 'Kotlin'),
    ('other_see_comments', _('offer.programming_language.other')),
)

HARDWARE_PROFILE_TYPES = Choices(
    ('no', _('offer.hardware_profile_type.no')),
    ('token', _('offer.hardware_profile_type.token')),
    ('laptop', _('offer.hardware_profile_type.laptop')),
)

BONUS_TYPES = Choices(
    ('welcome', _('offer.bonus.welcome')),
    ('signup', _('offer.bonus.signup')),
)

RELOCATION_PACKAGE = Choices(
    ('silver', _('offer.relocation_package.silver')),
    ('gold', _('offer.relocation_package.gold')),
    ('platinum', _('offer.relocation_package.platinum')),
)
