from django.db import models

from . import choices


class OfferQuerySet(models.QuerySet):

    def alive(self):
        return self.exclude(status__in=(
            choices.OFFER_STATUSES.closed,
            choices.OFFER_STATUSES.rejected,
            choices.OFFER_STATUSES.deleted,
        ))


class PositionQuerySet(models.QuerySet):

    def alive(self):
        return self.filter(is_deleted=False)


OfferManager = models.Manager.from_queryset(OfferQuerySet)
PositionManager = models.Manager.from_queryset(PositionQuerySet)
