# Generated by Django 1.11.2 on 2018-08-20 19:08
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager
import django.utils.timezone
import intranet.femida.src.core.db.fields
import intranet.femida.src.core.models
import model_utils.fields
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Link',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('uid', models.UUIDField(default=uuid.uuid4, editable=False)),
                ('expiration_date', models.DateField(null=True)),
                ('version', models.PositiveIntegerField(default=0, editable=False)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Offer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('version', models.PositiveIntegerField(default=0, editable=False)),
                ('newhire_id', models.PositiveIntegerField(blank=True, editable=False, null=True)),
                ('newhire_status', models.CharField(
                    blank=True,
                    choices=[
                        ('new', 'offer.newhire_status.new'),
                        ('prepared', 'offer.newhire_status.prepared'),
                        ('approved', 'offer.newhire_status.approved'),
                        ('ready', 'offer.newhire_status.ready'),
                        ('closed', 'offer.newhire_status.closed'),
                        ('cancelled', 'offer.newhire_status.cancelled'),
                    ],
                    max_length=20,
                    null=True,
                )),
                ('status', models.CharField(
                    choices=[
                        ('draft', 'offer.status.draft'),
                        ('ready_for_approval', 'offer.status.ready_for_approval'),
                        ('on_rotation_approval', 'offer.status.on_rotation_approval'),
                        ('on_approval', 'offer.status.on_approval'),
                        ('sent', 'offer.status.sent'),
                        ('accepted', 'offer.status.accepted'),
                        ('confirmed', 'offer.status.confirmed'),
                        ('closed', 'offer.status.closed'),
                        ('rejected', 'offer.status.rejected'),
                        ('deleted', 'offer.status.deleted'),
                    ],
                    default='draft',
                    max_length=20,
                )),
                ('closed_at', models.DateTimeField(blank=True, null=True)),
                ('full_name', models.CharField(max_length=255)),
                ('staff_position_name', models.CharField(max_length=255)),
                ('grade', models.PositiveSmallIntegerField(null=True)),
                ('need_help_in_adaptation', models.BooleanField(default=False)),
                ('join_at', models.DateField(null=True)),
                ('payment_type', models.CharField(
                    blank=True,
                    choices=[
                        ('monthly', 'offer.payment_type.monthly'),
                        ('hourly', 'offer.payment_type.hourly'),
                        ('piecework', 'offer.payment_type.piecework'),
                    ],
                    max_length=16,
                )),
                ('salary', models.DecimalField(
                    blank=True,
                    decimal_places=2,
                    max_digits=10,
                    null=True,
                    validators=[django.core.validators.MinValueValidator(0)],
                )),
                ('employment_type', models.CharField(
                    blank=True,
                    choices=[
                        ('full', 'offer.employment_type.full'),
                        ('partial', 'offer.employment_type.partial'),
                    ],
                    max_length=16,
                )),
                ('work_hours_weekly', models.IntegerField(blank=True, null=True)),
                ('is_main_work_place', models.BooleanField(default=True)),
                ('work_place', models.CharField(
                    blank=True,
                    choices=[
                        ('office', 'offer.work_place.office'),
                        ('home', 'offer.work_place.home'),
                    ],
                    max_length=16,
                )),
                ('homeworker_location', models.CharField(blank=True, max_length=255)),
                ('is_resident', models.BooleanField(default=True, verbose_name='Резидент (не используется FEMIDA-5420)')),
                ('is_intern', models.BooleanField(default=False)),
                ('contract_type', models.CharField(
                    blank=True,
                    choices=[
                        ('indefinite', 'offer.contract_type.indefinite'),
                        ('fixed_term', 'offer.contract_type.fixed_term'),
                        ('fixed_term_date', 'offer.contract_type.fixed_term_date'),
                        ('temp_replacement', 'offer.contract_type.temp_replacement'),
                        ('project', 'offer.contract_type.project'),
                    ],
                    max_length=16,
                )),
                ('contract_term', models.IntegerField(blank=True, null=True)),
                ('contract_term_date', models.DateField(blank=True, null=True)),
                ('probation_period', models.PositiveIntegerField(default=3)),
                ('probation_period_unit', models.CharField(choices=[('week', 'offer.probation_period_unit.week'), ('month', 'offer.probation_period_unit.month')], default='month', max_length=8)),
                ('vmi', models.BooleanField(default=False)),
                ('sick_leave_supplement', models.BooleanField(default=False)),
                ('housing_program', models.BooleanField(default=False)),
                ('cellular_compensation', models.BooleanField(default=False)),
                ('internet_compensation_amount', models.DecimalField(decimal_places=2, default=0, max_digits=10, validators=[django.core.validators.MinValueValidator(0)])),
                ('rsu', models.IntegerField(default=0, verbose_name='RSU (не используется FEMIDA-3395)')),
                ('rsu_cost', models.DecimalField(decimal_places=2, default=0, max_digits=10, null=True, validators=[django.core.validators.MinValueValidator(0)])),
                ('signup_bonus', models.DecimalField(decimal_places=2, default=0, max_digits=10, validators=[django.core.validators.MinValueValidator(0)])),
                ('allowance', models.DecimalField(decimal_places=2, default=0, max_digits=10, validators=[django.core.validators.MinValueValidator(0)])),
                ('need_relocation', models.BooleanField(default=False)),
                ('is_former_employee', models.BooleanField(default=False)),
                ('employee_type', models.CharField(
                    choices=[
                        ('new', 'offer.employee_type.new'),
                        ('former', 'offer.employee_type.former'),
                        ('current', 'offer.employee_type.current'),
                        ('rotation', 'offer.employee_type.rotation'),
                        ('intern', 'offer.employee_type.intern'),
                    ],
                    default='new',
                    max_length=16,
                    null=True,
                )),
                ('username', models.CharField(blank=True, max_length=50)),
                ('other_payments', models.CharField(blank=True, max_length=255)),
                ('professional_level', models.CharField(choices=[('intern', 'pro_level.intern'), ('junior', 'pro_level.junior'), ('middle', 'pro_level.middle'), ('senior', 'pro_level.senior'), ('lead', 'pro_level.lead'), ('expert', 'pro_level.expert')], max_length=16, null=True)),
                ('programming_language', models.CharField(
                    blank=True,
                    choices=[
                        ('c_plus_plus_lang', 'C++'),
                        ('c_lang', 'C'),
                        ('java_lang', 'Java'),
                        ('s\u0441ala_lang', 'Scala'),
                        ('c_sharp_lang', 'C#'),
                        ('lisp_lang', 'Lisp'),
                        ('erlang_lang', 'Erlang'),
                        ('haskell_lang', 'Haskell'),
                        ('go_lang', 'Go'),
                        ('python_lang', 'Python'),
                        ('perl_lang', 'Perl'),
                        ('ruby_lang', 'Ruby'),
                        ('javascript_lang', 'JavaScript'),
                        ('php_lang', 'PHP'),
                        ('objective_c_lang', 'Objective-C'),
                        ('swift_lang', 'Swift'),
                        ('kotlin', 'Kotlin'),
                        ('other_see_comments', 'offer.programming_language.other'),
                    ],
                    max_length=20,
                )),
                ('salary_expectations', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True, validators=[django.core.validators.MinValueValidator(0)])),
                ('current_company', models.CharField(blank=True, max_length=255)),
                ('source', models.CharField(
                    choices=[
                        ('internal_reference', 'offer.source.internal_reference'),
                        ('external_reference', 'offer.source.external_reference'),
                        ('rotation', 'offer.source.rotation'),
                        ('found_by_hiring_manager', 'offer.source.found_by_hiring_manager'),
                        ('academic_project', 'offer.source.academic_project'),
                        ('expert_evaluation', 'offer.source.expert_evaluation'),
                        ('candidates_list', 'offer.source.candidates_list'),
                        ('agency', 'offer.source.agency'),
                        ('implant', 'offer.source.implant'),
                        ('yandex_job_website', 'offer.source.yandex_job_website'),
                        ('candidates_base', 'offer.source.candidates_base'),
                        ('external_website', 'offer.source.external_website'),
                        ('internal_event', 'offer.source.internal_event'),
                        ('external_event', 'offer.source.external_event'),
                        ('networking', 'offer.source.networking'),
                        ('other', 'offer.source.other'),
                    ],
                    default='other',
                    max_length=32,
                )),
                ('source_description', models.CharField(blank=True, max_length=255)),
                ('form_type', models.CharField(choices=[('russian', 'offer.form_type.russian'), ('international', 'offer.form_type.international')], default='russian', max_length=16)),
                ('startrek_hr_key', intranet.femida.src.core.db.fields.StartrekIssueKeyField(blank=True, max_length=32, null=True)),
                ('startrek_adaptation_key', intranet.femida.src.core.db.fields.StartrekIssueKeyField(blank=True, max_length=32, null=True)),
                ('startrek_hdrfs_key', intranet.femida.src.core.db.fields.StartrekIssueKeyField(blank=True, max_length=32, null=True)),
            ],
            options={
                'default_manager_name': 'unsafe',
                'verbose_name': '\u043e\u0444\u0444\u0435\u0440',
                'verbose_name_plural': '\u043e\u0444\u0444\u0435\u0440\u044b',
            },
            managers=[
                ('unsafe', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='OfferAttachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('type', models.CharField(
                    choices=[
                        ('document', 'offer_attachment.type.document'),
                        ('photo', 'offer_attachment.type.photo'),
                        ('passport_page', 'offer_attachment.type.passport_page'),
                        ('snils', 'offer_attachment.type.snils'),
                        ('offer_pdf', 'offer_attachment.type.offer_pdf'),
                    ],
                    default='document',
                    max_length=16,
                )),
                ('is_active', models.BooleanField(default=True)),
            ],
            options={
                'db_table': 'offers_offerprofileattachment',
                'default_manager_name': 'unsafe',
            },
            managers=[
                ('unsafe', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='OfferProfile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('version', models.PositiveIntegerField(default=0, editable=False)),
                ('last_name', models.CharField(max_length=100, null=True)),
                ('first_name', models.CharField(max_length=50, null=True)),
                ('middle_name', models.CharField(blank=True, max_length=50, null=True)),
                ('last_name_en', models.CharField(max_length=100, null=True)),
                ('first_name_en', models.CharField(max_length=50, null=True)),
                ('gender', models.CharField(choices=[('M', 'offer_profile.gender.male'), ('F', 'offer_profile.gender.female')], max_length=1)),
                ('birthday', models.DateField(null=True)),
                ('citizenship', models.CharField(blank=True, choices=[('RU', 'offer_profile.citizenship.russian'), ('BY', 'offer_profile.citizenship.belorussian'), ('UA', 'offer_profile.citizenship.ukrainian'), ('KZ', 'offer_profile.citizenship.kazakhstan'), ('KG', 'offer_profile.citizenship.kyrgyzstan'), ('AM', 'offer_profile.citizenship.armenia'), ('ZZ', 'offer_profile.citizenship.other')], default='', max_length=2, null=True)),
                ('marital_status', models.CharField(blank=True, choices=[('free', 'offer_profile.marital_status.free'), ('married', 'offer_profile.marital_status.married')], max_length=16, null=True)),
                ('education', models.CharField(blank=True, choices=[('secondary', 'offer_profile.education.secondary'), ('incomplete', 'offer_profile.education.incomplete'), ('bachelor', 'offer_profile.education.bachelor'), ('master', 'offer_profile.education.master'), ('specialist', 'offer_profile.education.specialist'), ('academic', 'offer_profile.education.academic')], default='', max_length=16)),
                ('education_direction', models.CharField(blank=True, choices=[('technical', 'offer_profile.education_direction.technical'), ('liberal', 'offer_profile.education_direction.liberal'), ('natural', 'offer_profile.education_direction.natural'), ('economic', 'offer_profile.education_direction.economic'), ('business', 'offer_profile.education_direction.business')], default='', max_length=16)),
                ('educational_institution', models.CharField(blank=True, max_length=150, null=True)),
                ('education_end_date', models.DateField(blank=True, null=True)),
                ('residence_address', models.CharField(max_length=1024, null=True)),
                ('phone', models.CharField(max_length=50, null=True)),
                ('id_card', models.CharField(blank=True, max_length=30, null=True)),
                ('os', models.CharField(choices=[('kubuntu', 'offer_profile.operating_system.kubuntu'), ('ubuntu', 'offer_profile.operating_system.ubuntu'), ('mac', 'offer_profile.operating_system.mac'), ('windows', 'offer_profile.operating_system.windows'), ('none', 'offer_profile.operating_system.none')], max_length=16, null=True)),
                ('yandex_login', models.CharField(blank=True, max_length=50, null=True)),
                ('home_email', models.CharField(blank=True, max_length=50, null=True)),
                ('nda_accepted', models.BooleanField(default=False)),
            ],
            options={
                'verbose_name': '\u0430\u043d\u043a\u0435\u0442\u0430',
                'verbose_name_plural': '\u0430\u043d\u043a\u0435\u0442\u044b',
            },
        ),
        migrations.CreateModel(
            name='OfferProfileComment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('text', models.TextField()),
                ('is_hr', models.BooleanField(default=False)),
            ],
            options={
                'ordering': ('created',),
            },
        ),
        migrations.CreateModel(
            name='OfferRejection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('version', models.PositiveIntegerField(default=0, editable=False)),
                (
                    'rejection_reason',
                    models.CharField(
                        blank=True,
                        choices=[
                            ('tasks', 'offer.rejection_reason.tasks'),
                            ('team', 'offer.rejection_reason.team'),
                            ('personalReason', 'offer.rejection_reason.personal_reason'),
                            ('companyCulture', 'offer.rejection_reason.company_culture'),
                            ('money', 'offer.rejection_reason.money'),
                            ('salary', 'offer.rejection_reason.salary'),
                            ('movingAbroad', 'offer.rejection_reason.moving_abroad'),
                            ('other', 'offer.rejection_reason.other'),
                        ],
                        max_length=16,
                    ),
                ),
                ('competing_offer_conditions', models.TextField(blank=True)),
                ('competing_company', models.CharField(blank=True, max_length=255)),
                ('comment', models.TextField(blank=True)),
            ],
            options={
                'verbose_name': '\u043e\u0442\u043a\u0430\u0437 \u043e\u0442 \u043e\u0444\u0444\u0435\u0440\u0430',
                'verbose_name_plural': '\u043e\u0442\u043a\u0430\u0437\u044b \u043e\u0442 \u043e\u0444\u0444\u0435\u0440\u0430',
            },
        ),
        migrations.CreateModel(
            name='OfferTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('text', models.TextField()),
                ('is_active', models.BooleanField(default=True)),
                ('offer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='templates', to='offers.Offer')),
            ],
            options={
                'verbose_name': '\u0442\u0435\u043a\u0441\u0442 \u043e\u0444\u0444\u0435\u0440\u0430',
                'verbose_name_plural': '\u0442\u0435\u043a\u0441\u0442\u044b \u043e\u0444\u0444\u0435\u0440\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='Position',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name_ru', models.CharField(max_length=255)),
                ('name_en', models.CharField(blank=True, max_length=255)),
            ],
            options={
                'verbose_name': '\u0434\u043e\u043b\u0436\u043d\u043e\u0441\u0442\u044c',
                'verbose_name_plural': '\u0434\u043e\u043b\u0436\u043d\u043e\u0441\u0442\u0438',
            },
            bases=(intranet.femida.src.core.models.I18NNameModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='RawTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=255)),
                ('text', models.TextField()),
            ],
            options={
                'verbose_name': '\u0448\u0430\u0431\u043b\u043e\u043d \u0434\u043b\u044f \u043e\u0444\u0444\u0435\u0440\u0430',
                'verbose_name_plural': '\u0448\u0430\u0431\u043b\u043e\u043d\u044b \u0434\u043b\u044f \u043e\u0444\u0444\u0435\u0440\u0430',
            },
        ),
        migrations.AddField(
            model_name='offertemplate',
            name='raw_template',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='offers.RawTemplate'),
        ),
    ]
