# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2018-08-23 15:53
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import intranet.femida.src.core.db.fields
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('attachments', '0002_attachment_uploader'),
        ('offers', '0002_auto_20180820_1908'),
    ]

    operations = [
        migrations.CreateModel(
            name='Preprofile',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('id', models.PositiveIntegerField(primary_key=True, serialize=False)),
                ('data', django.contrib.postgres.fields.jsonb.JSONField(blank=True, null=True)),
                ('is_saved', models.BooleanField(default=False)),
                ('startrek_hr_key', intranet.femida.src.core.db.fields.StartrekIssueKeyField(blank=True, max_length=32)),
            ],
            options={
                'verbose_name': '\u043f\u0440\u0435\u043f\u0440\u043e\u0444\u0430\u0439\u043b \u0432 \u041d\u0430\u043d\u0438\u043c\u0430\u0442\u043e\u0440\u0435',
                'verbose_name_plural': '\u043f\u0440\u0435\u043f\u0440\u043e\u0444\u0430\u0439\u043b\u044b \u0432 \u041d\u0430\u043d\u0438\u043c\u0430\u0442\u043e\u0440\u0435',
            },
        ),
        migrations.CreateModel(
            name='PreprofileAttachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('type', models.CharField(
                    choices=[
                        ('document', 'offer_attachment.type.document'),
                        ('photo', 'offer_attachment.type.photo'),
                        ('passport_page', 'offer_attachment.type.passport_page'),
                        ('snils', 'offer_attachment.type.snils'),
                        ('offer_pdf', 'offer_attachment.type.offer_pdf'),
                    ],
                    default='document',
                    max_length=16,
                )),
                ('is_active', models.BooleanField(default=True)),
                ('attachment', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='preprofile_attachments', to='attachments.Attachment')),
                ('preprofile', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='preprofile_attachments', to='offers.Preprofile')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AlterField(
            model_name='link',
            name='offer',
            field=models.OneToOneField(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, to='offers.Offer'),
        ),
        migrations.AddField(
            model_name='preprofile',
            name='attachments',
            field=models.ManyToManyField(related_name='preprofiles', through='offers.PreprofileAttachment', to='attachments.Attachment'),
        ),
        migrations.AddField(
            model_name='link',
            name='preprofile',
            field=models.OneToOneField(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, to='offers.Preprofile'),
        ),
    ]
