import logging

from django.db import migrations

from intranet.femida.src.offers.choices import EMPLOYMENT_TYPES


logger = logging.getLogger(__name__)


def update_work_hours(apps, schema_editor):
    Offer = apps.get_model('offers', 'Offer')
    count = (
        Offer.unsafe
        .filter(work_hours_weekly__isnull=True, employment_type=EMPLOYMENT_TYPES.full)
        .update(work_hours_weekly=40)
    )
    logger.info('Updated %d offers', count)


def return_work_hours(apps, schema_editor):
    Offer = apps.get_model('offers', 'Offer')
    count = (
        Offer.unsafe
        .filter(work_hours_weekly__isnull=False, employment_type=EMPLOYMENT_TYPES.full)
        .update(work_hours_weekly=None)
    )
    logger.info('Updated %d offers', count)


class Migration(migrations.Migration):

    dependencies = [
        ('offers', '0022_add_hourly_rate'),
    ]

    operations = [
        migrations.RunPython(update_work_hours, reverse_code=return_work_hours),
    ]
