# Generated by Django 2.2.9 on 2020-05-28 14:46
from datetime import datetime

from django.db import migrations


def copy_link_expiration_date(apps, schema_editor):
    Link = apps.get_model('offers', 'Link')
    links = Link.objects.filter(expiration_time__isnull=True)
    zero_time = datetime.min.timetz()
    for link in links:
        if link.expiration_date:
            link.expiration_time = datetime.combine(link.expiration_date, zero_time)
    Link.objects.bulk_update(links, ['expiration_time'], batch_size=100)


class Migration(migrations.Migration):

    dependencies = [
        ('offers', '0026_link_expiration_time'),
    ]

    operations = [
        migrations.RunPython(copy_link_expiration_date, reverse_code=lambda *x, **y: None),
    ]

