# Generated by Django 2.2.9 on 2020-08-17 13:03

from django.db import migrations
from django.db.models import F


def status_to_resolution(apps, schema_editor):
    Offer = apps.get_model('offers', 'Offer')
    processed_offers = Offer.unsafe.filter(docs_processing_status='finished')
    processed_offers.update(docs_processing_resolution='processed')
    offers = Offer.unsafe.filter(docs_processing_status__in=('expired', 'failed'))
    offers.update(
        docs_processing_status='finished',
        docs_processing_resolution=F('docs_processing_status'),
    )


def resolution_to_status(apps, schema_editor):
    Offer = apps.get_model('offers', 'Offer')
    offers = Offer.unsafe.filter(docs_processing_resolution__in=('expired', 'failed'))
    offers.update(docs_processing_status=F('docs_processing_resolution'))


class Migration(migrations.Migration):

    dependencies = [
        ('offers', '0029_offer_docs_processing_resolution'),
    ]

    operations = [
        migrations.RunPython(status_to_resolution, resolution_to_status),
    ]
