# Generated by Django 2.2.28 on 2022-05-13 10:14

from django.db import migrations


def fill_relocation_packages(apps, schema_editor):
    RelocationPackage = apps.get_model('offers', 'RelocationPackage')
    relocation_packages = [
        {'type': 'silver', 'base_allowance': 66990, 'min_grade': 13, 'max_grade': 15},
        {'type': 'gold', 'base_allowance': 133980, 'min_grade': 16, 'max_grade': 18},
        {'type': 'platinum', 'base_allowance': 133980, 'min_grade': 19, 'max_grade': 30},
    ]

    for data in relocation_packages:
        RelocationPackage.objects.create(**data)


class Migration(migrations.Migration):

    dependencies = [
        ('offers', '0042_relocation_package'),
    ]

    operations = [
        migrations.RunPython(fill_relocation_packages, migrations.RunPython.noop),
    ]
