import sform

from intranet.femida.src.api.core.forms import UserSuggestField, DepartmentSuggestField
from intranet.femida.src.offers.choices import (
    EMPLOYEE_TYPES,
    OFFER_NEWHIRE_STATUSES,
    CITIZENSHIP,
    GENDER,
)
from intranet.femida.src.staff.models import Organization


class NewhireOfferRemoteForm(sform.SForm):

    join_at = sform.DateField()
    employee_type = sform.ChoiceField(choices=EMPLOYEE_TYPES)
    username = sform.CharField()
    startrek_hdrfs_key = sform.CharField()
    newhire_status = sform.ChoiceField(choices=OFFER_NEWHIRE_STATUSES)


class NewhirePreprofileRemoteForm(sform.SForm):

    org = sform.ModelChoiceField(
        queryset=Organization.objects.all(),
        label_extractor=str,
        state=sform.REQUIRED,
    )
    last_name = sform.CharField()
    first_name = sform.CharField()
    middle_name = sform.CharField()
    last_name_en = sform.CharField()
    first_name_en = sform.CharField()
    newhire_status = sform.ChoiceField(choices=OFFER_NEWHIRE_STATUSES)
    employee_type = sform.ChoiceField(choices=EMPLOYEE_TYPES)
    username = sform.CharField()
    join_at = sform.DateField()
    department = DepartmentSuggestField()
    boss = UserSuggestField()
    recruiter = UserSuggestField()
    position = sform.CharField()
    citizenship = sform.ChoiceField(choices=CITIZENSHIP)

    # Поля, которые не отдает Наниматор,
    # но они есть у нас из внешней анкеты.
    # Нужны для HR-тикета
    gender = sform.ChoiceField(choices=GENDER)
    birthday = sform.DateField()
    phone = sform.CharField()
    home_email = sform.EmailField()
    residence_address = sform.CharField()
