from dateutil.relativedelta import relativedelta
from rest_framework import serializers

from intranet.femida.src.offers.choices import CONTRACT_TYPES, WORK_PLACES
from intranet.femida.src.utils.translation import get_name_field, get_localized_name_field


class NameField(serializers.ReadOnlyField):
    """
    Задел на будущее, чтобы можно было отдавать локализованные name поля.
    В дальнейшем язык скорее всего будет определяться по form_type.
    """
    def __init__(self, source=None, getter=None):
        super().__init__(source='*')
        self._source = source
        self._getter = getter or get_name_field

    def get_attribute(self, instance):
        language = 'ru'
        name_field = self._getter(language)
        source = self._source or self.field_name
        self.source = f'{source}.{name_field}'
        self.source_attrs = self.source.split('.')
        return super().get_attribute(instance)


class OfferBPLogSerializer(serializers.Serializer):

    salary = serializers.FloatField()
    join_at = serializers.DateField()


class OebsFormulaOfferSerializer(serializers.Serializer):
    """
    Сериализация оффера для отправки в OEBS ручку генерации пдфки оффера
    """
    offerPeriod = serializers.SerializerMethodField()
    name = serializers.ReadOnlyField(source='candidate.first_name')
    salary = serializers.IntegerField()
    salaryCurrency = serializers.ReadOnlyField(source='payment_currency.code')
    firstSignUp = serializers.IntegerField(source='signup_bonus_gross')
    secondSignUp = serializers.IntegerField(source='signup_2year_bonus_gross')
    relocationPackage = serializers.ReadOnlyField(source='relocation_package')
    relocationAllowance = serializers.IntegerField(source='allowance')
    firstWelcomeBonus = serializers.IntegerField(source='welcome_bonus_gross')
    secondWelcomeBonus = serializers.IntegerField(source='welcome_2year_bonus_gross')
    startOption = serializers.IntegerField(source='rsu_cost')
    bpNumber = serializers.ReadOnlyField(source='vacancy.budget_position_id')
    jobName = NameField(source='position')
    organizationName = NameField(source='department', getter=get_localized_name_field)
    grade = serializers.ReadOnlyField()
    weeklyHours = serializers.ReadOnlyField(source='work_hours_weekly')
    housingProgram = serializers.SerializerMethodField()
    dms = serializers.BooleanField(source='vmi')
    food = serializers.SerializerMethodField()
    parking = serializers.SerializerMethodField()

    def get_offerPeriod(self, obj):
        offer_period = obj.join_at + relativedelta(months=1)
        return offer_period.strftime('%m.%Y')

    def get_housingProgram(self, obj):
        return obj.housing_program and obj.contract_type == CONTRACT_TYPES.indefinite

    def get_food(self, obj):
        return self.root.context['ctl'].has_food_compensation

    def get_parking(self, obj):
        return obj.work_place == WORK_PLACES.office
