from threading import local

from django.contrib.auth import get_user_model


class EmptyContextException(Exception):
    pass


class PermissionContext:

    def __init__(self):
        self._data = local()
        self._data.user = None

    def init(self, user):
        self._data.user = user

    def init_by_id(self, user_id):
        user = get_user_model().objects.get(id=user_id)
        self.init(user)

    def init_by_username(self, username):
        user = get_user_model().objects.get(username=username)
        self.init(user)

    def reset(self):
        self._data.user = None

    @property
    def user(self):
        if self._data.user is None:
            raise EmptyContextException
        return self._data.user


context = PermissionContext()
