import json

from constance import config


def get_manager(model_class, unsafe=False):
    if unsafe and hasattr(model_class, 'unsafe'):
        return model_class.unsafe
    else:
        return model_class.objects


def _is_tirole_enabled():
    """
    Надо будет настроить выгрузку
    """
    return False


def has_service_permission(yauser, perm):
    is_tvm_request = yauser.is_authenticated() and yauser.authenticated_by.mechanism_name == 'tvm'
    if not is_tvm_request:
        return False
    if not _is_tirole_enabled():
        permissions = json.loads(config.SERVICE_PERMISSIONS)
        return perm in permissions.get(str(yauser.service_ticket.src), [])
    tvm_client = yauser.authenticated_by.tvm._context
    roles = tvm_client.get_roles()
    return roles.check_service_role(yauser.service_ticket, f'/role/{perm}/')
