from django.db.models import Q
import waffle

from .base import PermQuery, PermManager, PermQueryBuilder, EmptyQException


class DuplicationCasePermQueryBuilder(PermQueryBuilder):

    def get_perm_q(self):
        is_recruiter = self.user.is_recruiter or self.user.is_recruiter_assessor
        if is_recruiter and not waffle.switch_is_active('is_rkn'):
            return (
                ~Q(first_candidate__login=self.user.username)
                & ~Q(second_candidate__login=self.user.username)
            )

        raise EmptyQException


class DuplicationCasePermQuery(PermQuery):

    _perm_query_builder_cls = DuplicationCasePermQueryBuilder


class DuplicationCasePermManager(PermManager):

    _perm_query_cls = DuplicationCasePermQuery
