from intranet.femida.src.interviews.managers import InterviewManager
from intranet.femida.src.permissions.managers.base import PermManager
from intranet.femida.src.permissions.managers.candidate import (
    CandidatePermQuery,
    CandidatePermQueryBuilder
)


class InterviewPermQueryBuilder(CandidatePermQueryBuilder):
    """" См. FEMIDA-7066, HRTOOLS-458
         Мы ограничили доступ к коллегам в базовом классе.
         Интервьюверы должны вести интервью даже у коллег,
         доступ к интервью ограничивать нельзя.
    """
    @property
    def vacancies_membership_q(self):
        return self.vacancies_membership_not_filtered_q

    @property
    def interviewed_q(self):
        return self.interviewed_not_filtered_q


class InterviewPermQuery(CandidatePermQuery):

    _perm_query_builder_cls = InterviewPermQueryBuilder


class InterviewPermManager(InterviewManager, PermManager):

    _perm_query_cls = InterviewPermQuery

    def __init__(self):
        super().__init__(perm_prefix='candidate')
