from django.db.models import Q

from intranet.femida.src.offers.managers import OfferManager

from .base import PermQuery, PermManager, PermQueryBuilder


class OfferPermQueryBuilder(PermQueryBuilder):
    """
    https://st.yandex-team.ru/FEMIDA-1311
    """
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

        ls = lambda s: s.lstrip('__')

        self.vacancy_in_k = ls(self.prefix + '__vacancy_id__in')

    def get_perm_q(self):
        if self.user.is_recruiting_manager:
            return None

        return self.vacancies_membership_q

    @property
    def vacancies_membership_q(self):
        from intranet.femida.src.vacancies.models import VacancyMembership
        from intranet.femida.src.vacancies.choices import VACANCY_ROLES

        roles = [VACANCY_ROLES.hiring_manager]
        if self.user.is_recruiter:
            roles += [VACANCY_ROLES.main_recruiter, VACANCY_ROLES.recruiter]
        if self.user.is_hrbp:
            roles += [VACANCY_ROLES.auto_observer, VACANCY_ROLES.observer]
        return Q(
            **{self.vacancy_in_k: (
                VacancyMembership.unsafe
                .filter(member=self.user, role__in=roles)
                .values('vacancy')
            )}
        )


class OfferPermQuery(PermQuery):
    _perm_query_builder_cls = OfferPermQueryBuilder


class OfferPermManager(OfferManager, PermManager):
    _perm_query_cls = OfferPermQuery
