import waffle

from intranet.femida.src.permissions.managers.base import EmptyQException
from .base import PermQuery, PermManager, PermQueryBuilder


class SubmissionPermQueryBuilder(PermQueryBuilder):

    def get_perm_q(self):
        if self.user.is_recruiter:
            return None

        is_enabled_for_assessors = (
            self.user.is_recruiter_assessor
            and waffle.switch_is_active('enable_submissions_for_recruiter_assessors')
        )
        if is_enabled_for_assessors:
            return None

        raise EmptyQException


class SubmissionPermQuery(PermQuery):
    _perm_query_builder_cls = SubmissionPermQueryBuilder


class SubmissionPermManager(PermManager):
    _perm_query_cls = SubmissionPermQuery
