from django.core.exceptions import PermissionDenied
from django.utils.deprecation import MiddlewareMixin

from .context import context
from .helpers import has_service_permission


class PermissionsContextMiddleware(MiddlewareMixin):

    def process_request(self, request):
        context.init(request.user)

    def process_response(self, request, response):
        context.reset()
        return response


class CheckTvmPermissionMiddleware(MiddlewareMixin):
    """
    Проверяет, что TVM-приложению можно приходить в Фемиду.
    По логике заменяет настройку YAUTH_TVM2_ALLOWED_CLIENT_IDS
    """
    def process_request(self, request):
        is_not_authorized = (
            request.yauser.is_authenticated()
            and request.yauser.authenticated_by.mechanism_name == 'tvm'
            and not has_service_permission(request.yauser, 'permissions.can_access_femida')
        )
        if is_not_authorized:
            raise PermissionDenied
