from django.contrib import admin

from . import models


class CategoryAdmin(admin.ModelAdmin):
    pass


class ProblemAdmin(admin.ModelAdmin):

    raw_id_fields = (
        'created_by',
        'original',
        'fans',
    )

    filter_horizontal = ('categories',)

    search_fields = (
        'id',
        'summary',
    )

    list_display = (
        'summary',
        'description',
        'deleted',
    )

    list_filter = (
        'deleted',
        'categories',
    )


class PresetAdmin(admin.ModelAdmin):

    raw_id_fields = (
        'created_by',
    )

    search_fields = (
        'id',
        'name',
    )

    list_display = (
        'name',
        'created_by',
    )

    list_select_related = (
        'created_by',
    )


class ComplaintAdmin(admin.ModelAdmin):

    raw_id_fields = (
        'created_by',
        'closed_by',
        'problem',
        'original_problem',
    )

    search_fields = (
        'id',
        'problem__id',
        'original_problem__id',
    )

    list_display = (
        'id',
        'created_by',
        'closed_by',
        'problem',
        'kind',
        'is_active',
    )

    list_filter = (
        'kind',
        'is_active',
    )

    list_select_related = (
        'created_by',
        'closed_by',
        'problem',
    )


admin.site.register(models.Category, CategoryAdmin)
admin.site.register(models.Problem, ProblemAdmin)
admin.site.register(models.Preset, PresetAdmin)
admin.site.register(models.Complaint, ComplaintAdmin)
