from model_utils.choices import Choices

from django.utils.translation import ugettext_noop as _


COMPLAINT_KINDS = Choices(
    ('duplicate', _('complaint.kind.duplicate')),
    ('improve_description', _('complaint.kind.improve_description')),
    ('incorrect_problem', _('complaint.kind.incorrect_problem')),
    ('other', _('complaint.kind.other')),
)


COMPLAINT_KINDS_TRANSLATIONS = Choices(
    (COMPLAINT_KINDS.duplicate, 'Дубликат'),
    (COMPLAINT_KINDS.improve_description, 'Улучшить описание задачи'),
    (COMPLAINT_KINDS.incorrect_problem, 'Некорректная задача'),
    (COMPLAINT_KINDS.other, 'Другое'),
)


COMPLAINT_RESOLUTIONS = Choices(
    ('rejected', _('complaint.resolution.rejected')),
    ('resolved', _('complaint.resolution.resolved')),
)


PROBLEM_SORTING_TYPES = Choices(
    ('rank', _('problem.sorting.rank')),
    ('id', _('problem.sorting.id')),
    ('popularity', _('problem.sorting.popularity')),
)
