from intranet.femida.src.problems.models import Complaint
from intranet.femida.src.notifications.problems import ComplaintCreatedNotification


def create_complaint(data, initiator=None):
    instance = Complaint.objects.create(
        created_by=initiator,
        **data
    )
    notification = ComplaintCreatedNotification(instance, initiator)
    notification.send()
    return instance


def close_complaint(instance, initiator, resolution=''):
    instance.is_active = False
    instance.closed_by = initiator
    instance.resolution = resolution
    instance.save()
    return instance
