# Generated by Django 1.11.2 on 2018-08-20 19:08
import django.contrib.postgres.search
from django.db import migrations, models
import django.utils.timezone
import intranet.femida.src.wf.models
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=100)),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Complaint',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_active', models.BooleanField(default=True)),
                ('comment', models.TextField(blank=True, default='')),
                ('kind', models.CharField(choices=[
                    ('duplicate', '\u0414\u0443\u0431\u043b\u0438\u043a\u0430\u0442'),
                    ('improve_description', '\u0423\u043b\u0443\u0447\u0448\u0438\u0442\u044c \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0437\u0430\u0434\u0430\u0447\u0438'),
                    ('incorrect_problem', '\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u0437\u0430\u0434\u0430\u0447\u0430'),
                    ('other', '\u0414\u0440\u0443\u0433\u043e\u0435')
                ], default='other', max_length=64)),
                ('resolution', models.CharField(blank=True, choices=[('rejected', 'complaint.resolution.rejected'), ('resolved', 'complaint.resolution.resolved')], default='', max_length=64)),
            ],
            options={
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Preset',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=100)),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='PresetProblem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('position', models.IntegerField(default=0)),
            ],
            options={
                'ordering': ['position'],
            },
        ),
        migrations.CreateModel(
            name='Problem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('summary', models.CharField(max_length=255)),
                ('description', models.TextField(default='')),
                ('formatted_description', models.TextField(default='')),
                ('solution', models.TextField(blank=True, default='')),
                ('formatted_solution', models.TextField(blank=True, default='')),
                ('is_deprecated', models.BooleanField(default=False)),
                ('deleted', models.BooleanField(default=False)),
                ('search_vector', django.contrib.postgres.search.SearchVectorField()),
                ('categories', models.ManyToManyField(related_name='problems', to='problems.Category')),
            ],
            options={
                'ordering': ['-id'],
            },
            bases=(intranet.femida.src.wf.models.WFModelMixin, models.Model),
        ),
    ]
