# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2017-07-20 10:06
from django.db import migrations
from django.db.models import F
from django.conf import settings


def fill_search_vector(apps, schema_editor):
    Problem = apps.get_model("problems", "Problem")
    Problem.objects.update(summary=F('summary'))


def unfill_search_vector(apps, schema_editor):

    pass


# Note: Миграция потерялась при схлопывании всех миграций.
# На давно существующих базах нужно выполнить через
# femida migrate problems 0004 --fake
class Migration(migrations.Migration):

    dependencies = [
        ('core', '0003_pg_full_text_search_config'),
        ('problems', '0003_complaint_formatted_comment'),
    ]

    operations = [
        # Index for full text search
        migrations.RunSQL(
            sql=(
                "CREATE INDEX problems_problem_full_search_idx "
                "ON problems_problem "
                "USING GIN (search_vector)"
            ),
            reverse_sql="DROP INDEX IF EXISTS problems_problem_full_search_idx",
        ),

        # Trigger for auto updating vector field
        migrations.RunSQL(
            sql=(
                "CREATE FUNCTION problem_update_search_vector() RETURNS trigger AS $$ "
                "begin "
                "  new.search_vector := "
                "    setweight(to_tsvector('{search_config}', cast(new.id as varchar)), 'A') ||"
                "    setweight(to_tsvector('{search_config}', coalesce(new.summary,'')), 'B') || "
                "    setweight(to_tsvector('{search_config}', coalesce(new.description,'') || ' ' || coalesce(new.solution)), 'C'); "
                "  return new; "
                "end "
                "$$ LANGUAGE plpgsql; "

                "CREATE TRIGGER problem_search_vector_update "
                "BEFORE INSERT OR UPDATE "
                "ON problems_problem "
                "FOR EACH ROW EXECUTE PROCEDURE problem_update_search_vector(); ".format(
                    search_config=settings.PG_TEXT_SEARCH_CONFIG,
                )
            ),
            reverse_sql=(
                "DROP TRIGGER IF EXISTS problem_search_vector_update ON problems_problem; "
                "DROP FUNCTION IF EXISTS problem_update_search_vector(); "
            ),
        ),

        # Fill search vector
        migrations.RunPython(fill_search_vector, unfill_search_vector),
    ]
