# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2019-09-05 21:10
from django.db import migrations

from intranet.femida.src.problems.choices import COMPLAINT_KINDS


def merge_complaint_choices(apps, schema_editor):
    Complaint = apps.get_model('problems', 'Complaint')
    Complaint.objects.filter(
        kind__in=(
            'no_solution',
            'incorrect_description',
        )
    ).update(
        kind=COMPLAINT_KINDS.improve_description,
    )


class Migration(migrations.Migration):

    dependencies = [
        ('problems', '0004_problem_full_text_search_setup'),
    ]

    operations = [
        migrations.RunPython(merge_complaint_choices, reverse_code=lambda *x, **y: None)
    ]
