import logging

from intranet.femida.src.core.controllers import update_instance
from intranet.femida.src.core.workflow import Action, Workflow
from intranet.femida.src.problems.controllers import add_problems_from_preset
from intranet.femida.src.problems.models import PresetProblem
from intranet.femida.src.problems.utils import reorder_preset


logger = logging.getLogger(__name__)


class PresetActionBase(Action):

    def has_permission(self):
        return self.user.is_superuser or self.instance.created_by == self.user


class UpdateAction(PresetActionBase):

    def perform(self, **params):
        return update_instance(self.instance, params)


class ProblemAddAction(PresetActionBase):

    def perform(self, **params):
        problem = params.get('problem')
        preset_problem = PresetProblem.objects.filter(preset=self.instance, problem=problem).first()
        if preset_problem is None:
            preset_problem = PresetProblem.objects.create(preset=self.instance, problem=problem)
        return preset_problem


class ProblemRemoveAction(PresetActionBase):

    def perform(self, **params):
        problem = params.get('problem')
        preset_problem = PresetProblem.objects.filter(preset=self.instance, problem=problem).first()
        if preset_problem:
            preset_problem.delete()


class ReorderAction(PresetActionBase):

    def perform(self, **params):
        problem_ids = params.get('problem_ids')
        reorder_preset(self.instance, problem_ids)
        return self.instance


class AddProblemsFromPresetAction(PresetActionBase):

    def perform(self, **params):
        add_problems_from_preset(
            link_model_class=PresetProblem,
            preset=params['preset'],
            target=self.instance,
            target_field_name='preset',
        )
        return self.instance


class PresetWorkflow(Workflow):

    ACTION_MAP = {
        'update': UpdateAction,
        'problem_add': ProblemAddAction,
        'problem_remove': ProblemRemoveAction,
        'reorder': ReorderAction,
        'add_problems_from_preset': AddProblemsFromPresetAction,
    }
