from django.contrib import admin

from intranet.femida.src.hh.admin import EntityLinkInlineAdmin

from . import models


class ProfessionalSphereAdmin(admin.ModelAdmin):

    search_fields = (
        'name',
        'name_en',
    )

    list_display = (
        'id',
        'name',
        'name_en',
        'position',
        'is_active',
        'slug',
    )

    list_filter = (
        'is_active',
    )

    list_editable = (
        'name',
        'name_en',
        'position',
        'is_active',
        'slug',
    )


class ProfessionAdmin(admin.ModelAdmin):

    search_fields = (
        'name',
        'professional_sphere__name',
    )

    list_display = (
        'id',
        'name',
        'professional_sphere',
        'prof_sphere_is_active',
        'position',
        'startrek_id',
        'is_active',
        'staff_id',
        'slug',
    )

    list_filter = (
        'is_active',
        'professional_sphere',
    )

    list_editable = (
        'position',
        'is_active',
        'startrek_id',
        'staff_id',
        'slug',
    )

    inlines = (
        EntityLinkInlineAdmin,
    )

    def prof_sphere_is_active(self, obj):
        return obj.professional_sphere.is_active
    prof_sphere_is_active.short_description = 'is sphere active'
    prof_sphere_is_active.boolean = True


admin.site.register(models.ProfessionalSphere, ProfessionalSphereAdmin)
admin.site.register(models.Profession, ProfessionAdmin)
