# Generated by Django 2.2.19 on 2021-04-21 13:26
import re

from django.db import migrations


def fill_slug(apps, schema_editor):
    Profession = apps.get_model('professions', 'Profession')
    professions = Profession.objects.all()

    rgx1 = re.compile(r'[^A-Za-z]')
    rgx2 = re.compile(r'(.)([A-Z][a-z]+)')
    rgx3 = re.compile(r'([a-z])([A-Z])')
    for p in professions:
        if not p.staff_id:
            continue

        cleaned_staff_id = re.sub(rgx1, '', p.staff_id)
        slug = re.sub(rgx2, r'\1-\2', cleaned_staff_id)
        p.slug = re.sub(rgx3, r'\1-\2', slug).lower()

    Profession.objects.bulk_update(professions, ['slug'], batch_size=100)


def clear_slug(apps, schema_editor):
    Profession = apps.get_model('professions', 'Profession')
    Profession.objects.update(slug=None)


class Migration(migrations.Migration):

    dependencies = [
        ('professions', '0003_profession_slug'),
    ]

    operations = [
        migrations.RunPython(code=fill_slug, reverse_code=clear_slug),
    ]

